/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.text.NumberFormat;
import java.util.Locale;
import org.python.core.Py;
import org.python.core.PyDictionary;
import org.python.core.PyException;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyLong;
import org.python.core.PyObject;
import org.python.core.PySequence;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PyTuple;
import org.python.core.PyUnicode;
import org.python.core.codecs;
import org.python.core.util.ExtraMath;

final class StringFormatter {
    int index = 0;
    String format;
    StringBuilder buffer;
    boolean negative;
    int precision;
    int argIndex;
    PyObject args;
    boolean unicodeCoercion;

    final char pop() {
        try {
            return this.format.charAt(this.index++);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw Py.ValueError("incomplete format");
        }
    }

    final char peek() {
        return this.format.charAt(this.index);
    }

    final void push() {
        --this.index;
    }

    public StringFormatter(String string) {
        this(string, false);
    }

    public StringFormatter(String string, boolean bl) {
        this.format = string;
        this.unicodeCoercion = bl;
        this.buffer = new StringBuilder(string.length() + 100);
    }

    PyObject getarg() {
        PyObject pyObject = null;
        switch (this.argIndex) {
            case -3: {
                return this.args;
            }
            case -2: {
                break;
            }
            case -1: {
                this.argIndex = -2;
                return this.args;
            }
            default: {
                pyObject = this.args.__finditem__(this.argIndex++);
            }
        }
        if (pyObject == null) {
            throw Py.TypeError("not enough arguments for format string");
        }
        return pyObject;
    }

    int getNumber() {
        char c = this.pop();
        if (c == '*') {
            PyObject pyObject = this.getarg();
            if (pyObject instanceof PyInteger) {
                return ((PyInteger)pyObject).getValue();
            }
            throw Py.TypeError("* wants int");
        }
        if (Character.isDigit(c)) {
            int n = this.index - 1;
            while (Character.isDigit(c = this.pop())) {
            }
            --this.index;
            Integer n2 = Integer.valueOf(this.format.substring(n, this.index));
            return n2;
        }
        --this.index;
        return 0;
    }

    private void checkPrecision(String string) {
        if (this.precision > 250) {
            throw Py.OverflowError("formatted " + string + " is too long (precision too long?)");
        }
    }

    private String formatLong(PyObject pyObject, char c, boolean bl) {
        PyString pyString;
        switch (c) {
            case 'o': {
                pyString = pyObject.__oct__();
                break;
            }
            case 'X': 
            case 'x': {
                pyString = pyObject.__hex__();
                break;
            }
            default: {
                pyString = pyObject.__str__();
            }
        }
        this.checkPrecision("long");
        String string = pyString.toString();
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        if (c == 'x' || c == 'X') {
            n3 = 2;
        }
        if (string.endsWith("L")) {
            --n;
        }
        boolean bl2 = this.negative = string.charAt(0) == '-';
        if (this.negative) {
            ++n2;
        }
        int n4 = n - n3 - n2;
        if (!bl) {
            switch (c) {
                case 'o': {
                    if (n4 <= 1) break;
                    ++n2;
                    --n4;
                    break;
                }
                case 'X': 
                case 'x': {
                    n2 += 2;
                    n3 -= 2;
                }
            }
        }
        if (this.precision > n4) {
            int n5;
            StringBuilder stringBuilder = new StringBuilder();
            for (n5 = 0; n5 < n3; ++n5) {
                stringBuilder.append(string.charAt(n2++));
            }
            for (n5 = 0; n5 < this.precision - n4; ++n5) {
                stringBuilder.append('0');
            }
            for (n5 = 0; n5 < n4; ++n5) {
                stringBuilder.append(string.charAt(n2++));
            }
            string = stringBuilder.toString();
        } else if (n < string.length() || n2 > 0) {
            string = string.substring(n2, n);
        }
        switch (c) {
            case 'X': {
                string = string.toUpperCase();
            }
        }
        return string;
    }

    private String formatInteger(PyObject pyObject, int n, boolean bl, char c, boolean bl2) {
        PyObject pyObject2;
        if (pyObject instanceof PyInteger || pyObject instanceof PyLong) {
            pyObject2 = pyObject;
        } else if (pyObject instanceof PyFloat) {
            pyObject2 = pyObject.__int__();
        } else {
            try {
                pyObject2 = pyObject.__getattr__("__int__").__call__();
            }
            catch (PyException pyException) {
                if (pyException.match(Py.AttributeError)) {
                    throw Py.TypeError("int argument required");
                }
                throw pyException;
            }
        }
        if (pyObject2 instanceof PyInteger) {
            return this.formatInteger(((PyInteger)pyObject2).getValue(), n, bl);
        }
        return this.formatLong(pyObject2, c, bl2);
    }

    private String formatInteger(long l, int n, boolean bl) {
        this.checkPrecision("integer");
        if (bl) {
            if (l < 0L) {
                l = 0x100000000L + l;
            }
        } else if (l < 0L) {
            this.negative = true;
            l = -l;
        }
        String string = Long.toString(l, n);
        while (string.length() < this.precision) {
            string = "0" + string;
        }
        return string;
    }

    private double asDouble(PyObject pyObject) {
        try {
            return pyObject.asDouble();
        }
        catch (PyException pyException) {
            throw !pyException.match(Py.TypeError) ? pyException : Py.TypeError("float argument required");
        }
    }

    private String formatFloatDecimal(double d, boolean bl) {
        this.checkPrecision("decimal");
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
        int n = this.precision;
        if (n == -1) {
            n = 6;
        }
        if (d < 0.0) {
            d = -d;
            this.negative = true;
        }
        numberFormat.setMaximumFractionDigits(n);
        numberFormat.setMinimumFractionDigits(bl ? 0 : n);
        numberFormat.setGroupingUsed(false);
        String string = numberFormat.format(d);
        return string;
    }

    private String formatFloatExponential(PyObject pyObject, char c, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        double d = this.asDouble(pyObject);
        boolean bl2 = false;
        if (d < 0.0) {
            d = -d;
            bl2 = true;
        }
        double d2 = 0.0;
        if (d > 0.0) {
            d2 = ExtraMath.closeFloor(Math.log10(d));
        }
        int n = this.precision;
        this.precision = 2;
        String string = this.formatInteger((long)d2, 10, false);
        if (this.negative) {
            this.negative = false;
            string = '-' + string;
        } else {
            string = '+' + string;
        }
        this.precision = n;
        double d3 = d / Math.pow(10.0, d2);
        stringBuilder.append(this.formatFloatDecimal(d3, bl));
        stringBuilder.append(c);
        stringBuilder.append(string);
        this.negative = bl2;
        return stringBuilder.toString();
    }

    public PyString format(PyObject pyObject) {
        PyObject pyObject2 = null;
        this.args = pyObject;
        boolean bl = this.unicodeCoercion;
        if (pyObject instanceof PyTuple) {
            this.argIndex = 0;
        } else {
            this.argIndex = -1;
            if (pyObject instanceof PyDictionary || pyObject instanceof PyStringMap || !(pyObject instanceof PySequence) && pyObject.__findattr__("__getitem__") != null) {
                pyObject2 = pyObject;
                this.argIndex = -3;
            }
        }
        while (this.index < this.format.length()) {
            int n;
            String string;
            char c;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            int n2 = -1;
            this.precision = -1;
            char c2 = this.pop();
            if (c2 != '%') {
                this.buffer.append(c2);
                continue;
            }
            c2 = this.pop();
            if (c2 == '(') {
                if (pyObject2 == null) {
                    throw Py.TypeError("format requires a mapping");
                }
                int n3 = 1;
                c = this.index;
                while (n3 > 0) {
                    c2 = this.pop();
                    if (c2 == ')') {
                        --n3;
                        continue;
                    }
                    if (c2 != '(') continue;
                    ++n3;
                }
                string = this.format.substring(c, this.index - 1);
                this.args = pyObject2.__getitem__(bl ? new PyUnicode(string) : new PyString(string));
            } else {
                this.push();
            }
            block24: while (true) {
                c2 = this.pop();
                switch (c2) {
                    case '-': {
                        bl2 = true;
                        continue block24;
                    }
                    case '+': {
                        bl3 = true;
                        continue block24;
                    }
                    case ' ': {
                        bl4 = true;
                        continue block24;
                    }
                    case '#': {
                        bl5 = true;
                        continue block24;
                    }
                    case '0': {
                        bl6 = true;
                        continue block24;
                    }
                }
                break;
            }
            this.push();
            n2 = this.getNumber();
            if (n2 < 0) {
                n2 = -n2;
                bl2 = true;
            }
            if ((c2 = this.pop()) == '.') {
                this.precision = this.getNumber();
                if (this.precision < -1) {
                    this.precision = 0;
                }
                c2 = this.pop();
            }
            if (c2 == 'h' || c2 == 'l' || c2 == 'L') {
                c2 = this.pop();
            }
            if (c2 == '%') {
                this.buffer.append(c2);
                continue;
            }
            PyObject pyObject3 = this.getarg();
            c = ' ';
            string = null;
            this.negative = false;
            c = bl6 ? (char)'0' : ' ';
            switch (c2) {
                case 's': {
                    if (pyObject3 instanceof PyUnicode) {
                        bl = true;
                    }
                }
                case 'r': {
                    c = ' ';
                    string = c2 == 's' ? (bl ? pyObject3.__unicode__().toString() : pyObject3.__str__().toString()) : pyObject3.__repr__().toString();
                    if (this.precision < 0 || string.length() <= this.precision) break;
                    string = string.substring(0, this.precision);
                    break;
                }
                case 'd': 
                case 'i': {
                    if (pyObject3 instanceof PyLong) {
                        string = this.formatLong(pyObject3, c2, bl5);
                        break;
                    }
                    string = this.formatInteger(pyObject3, 10, false, c2, bl5);
                    break;
                }
                case 'u': {
                    if (pyObject3 instanceof PyLong) {
                        string = this.formatLong(pyObject3, c2, bl5);
                        break;
                    }
                    if (pyObject3 instanceof PyInteger || pyObject3 instanceof PyFloat) {
                        string = this.formatInteger(pyObject3, 10, false, c2, bl5);
                        break;
                    }
                    throw Py.TypeError("int argument required");
                }
                case 'o': {
                    if (pyObject3 instanceof PyLong) {
                        string = this.formatLong(pyObject3, c2, bl5);
                        break;
                    }
                    if (pyObject3 instanceof PyInteger || pyObject3 instanceof PyFloat) {
                        string = this.formatInteger(pyObject3, 8, false, c2, bl5);
                        if (!bl5 || string.charAt(0) == '0') break;
                        string = "0" + string;
                        break;
                    }
                    throw Py.TypeError("int argument required");
                }
                case 'x': {
                    if (pyObject3 instanceof PyLong) {
                        string = this.formatLong(pyObject3, c2, bl5);
                        break;
                    }
                    if (pyObject3 instanceof PyInteger || pyObject3 instanceof PyFloat) {
                        string = this.formatInteger(pyObject3, 16, false, c2, bl5);
                        string = string.toLowerCase();
                        if (!bl5) break;
                        string = "0x" + string;
                        break;
                    }
                    throw Py.TypeError("int argument required");
                }
                case 'X': {
                    if (pyObject3 instanceof PyLong) {
                        string = this.formatLong(pyObject3, c2, bl5);
                        break;
                    }
                    if (pyObject3 instanceof PyInteger || pyObject3 instanceof PyFloat) {
                        string = this.formatInteger(pyObject3, 16, false, c2, bl5);
                        string = string.toUpperCase();
                        if (!bl5) break;
                        string = "0X" + string;
                        break;
                    }
                    throw Py.TypeError("int argument required");
                }
                case 'E': 
                case 'e': {
                    string = this.formatFloatExponential(pyObject3, c2, false);
                    break;
                }
                case 'F': 
                case 'f': {
                    string = this.formatFloatDecimal(this.asDouble(pyObject3), false);
                    break;
                }
                case 'G': 
                case 'g': {
                    int n4;
                    double d;
                    n = this.precision;
                    if (this.precision == -1) {
                        this.precision = 6;
                    }
                    int n5 = (int)ExtraMath.closeFloor(Math.log10(Math.abs((d = this.asDouble(pyObject3)) == 0.0 ? 1.0 : d)));
                    if (d == Double.POSITIVE_INFINITY) {
                        string = "inf";
                        break;
                    }
                    if (d == Double.NEGATIVE_INFINITY) {
                        string = "-inf";
                        break;
                    }
                    if (n5 >= -4 && n5 < this.precision) {
                        this.precision -= n5 + 1;
                        string = this.formatFloatDecimal(d, !bl5);
                        if (!bl5 || string.indexOf(46) != -1) break;
                        n4 = n - string.length();
                        string = string + '.';
                        if (n4 <= 0) break;
                        char[] cArray = new char[n4];
                        int n6 = 0;
                        while (n6 < n4) {
                            cArray[n6++] = 48;
                        }
                        string = string + new String(cArray);
                        break;
                    }
                    --this.precision;
                    string = this.formatFloatExponential(pyObject3, (char)(c2 - 2), !bl5);
                    break;
                }
                case 'c': {
                    int n4;
                    c = ' ';
                    if (pyObject3 instanceof PyString) {
                        string = ((PyString)pyObject3).toString();
                        if (string.length() != 1) {
                            throw Py.TypeError("%c requires int or char");
                        }
                        if (!(pyObject3 instanceof PyUnicode)) break;
                        bl = true;
                        break;
                    }
                    try {
                        n4 = pyObject3.__int__().asInt();
                    }
                    catch (PyException pyException) {
                        if (pyException.match(Py.AttributeError)) {
                            throw Py.TypeError("%c requires int or char");
                        }
                        throw pyException;
                    }
                    if (!bl) {
                        if (n4 < 0) {
                            throw Py.OverflowError("unsigned byte integer is less than minimum");
                        }
                        if (n4 > 255) {
                            throw Py.OverflowError("unsigned byte integer is greater than maximum");
                        }
                    } else if (n4 < 0 || n4 > 0x10FFFF) {
                        throw Py.OverflowError("%c arg not in range(0x110000) (wide Python build)");
                    }
                    string = new String(new int[]{n4}, 0, 1);
                    break;
                }
                default: {
                    throw Py.ValueError("unsupported format character '" + codecs.encode(Py.newString(c2), null, "replace") + "' (0x" + Integer.toHexString(c2) + ") at index " + (this.index - 1));
                }
            }
            n = string.length();
            int n7 = 0;
            String string2 = null;
            if (this.negative) {
                string2 = "-";
            } else if (bl3) {
                string2 = "+";
            } else if (bl4) {
                string2 = " ";
            }
            if (n2 < n) {
                n2 = n;
            }
            if (string2 != null) {
                if (c != ' ') {
                    this.buffer.append(string2);
                }
                if (n2 > n) {
                    --n2;
                }
            }
            if (bl5 && (c2 == 'x' || c2 == 'X')) {
                if (c != ' ') {
                    this.buffer.append('0');
                    this.buffer.append(c2);
                    n7 += 2;
                }
                if ((n2 -= 2) < 0) {
                    n2 = 0;
                }
                n -= 2;
            }
            if (n2 > n && !bl2) {
                do {
                    this.buffer.append(c);
                } while (--n2 > n);
            }
            if (c == ' ') {
                if (string2 != null) {
                    this.buffer.append(string2);
                }
                if (bl5 && (c2 == 'x' || c2 == 'X')) {
                    this.buffer.append('0');
                    this.buffer.append(c2);
                    n7 += 2;
                }
            }
            if (n7 > 0) {
                this.buffer.append(string.substring(n7));
            } else {
                this.buffer.append(string);
            }
            while (--n2 >= n) {
                this.buffer.append(' ');
            }
        }
        if (this.argIndex == -1 || this.argIndex >= 0 && pyObject.__finditem__(this.argIndex) != null) {
            throw Py.TypeError("not all arguments converted during string formatting");
        }
        if (bl) {
            return new PyUnicode(this.buffer);
        }
        return new PyString(this.buffer);
    }
}

